IF EXISTS ( SELECT * 
            FROM   sysobjects 
            WHERE  id = object_id(N'dbo.CPJ_Asiento_Resumen_Generar') 
                   and OBJECTPROPERTY(id, N'IsProcedure') = 1 )
BEGIN
    DROP PROCEDURE dbo.CPJ_Asiento_Resumen_Generar
END
GO

CREATE PROCEDURE [dbo].[CPJ_Asiento_Resumen_Generar] @pJsonRecibido VARCHAR(8000)
AS 
SET NOCOUNT ON
/*Parametros*/

DECLARE 	@pFechaDesde			DATETIME,
			@pFechaHasta			DATETIME,
			@pId_Unid_Negocio       VARCHAR(10),
			@pFiltrar_No_Contab     TINYINT,
			@pTipo                  Smallint,
			@pIncluir_Ajustes       TINYINT,
            @pId_Plan_Cta           SMALLINT,
            @pGenerar_Asiento       TINYINT,
			@pFecha                 DATETIME,
            @pDescripcion           VARCHAR(100)

SET @pId_Unid_Negocio			= ISNULL(CONVERT(VARCHAR(10), dbo.CF_JSON_VALUE(@pJsonRecibido,'Id_Unid_Negocio')),'')
SET @pFechaDesde				= ISNULL(CONVERT(DATETIME, dbo.CF_JSON_VALUE(@pJsonRecibido,'FechaDesde')),GETDATE())
SET @pFechaHasta				= ISNULL(CONVERT(DATETIME, dbo.CF_JSON_VALUE(@pJsonRecibido,'FechaHasta')),GETDATE())
SET @pFiltrar_No_Contab			= ISNULL(CONVERT(TINYINT, dbo.CF_JSON_VALUE(@pJsonRecibido,'Filtrar_No_Contab')),0)
SET @pTipo		             	= ISNULL(CONVERT(SMALLINT, dbo.CF_JSON_VALUE(@pJsonRecibido,'Tipo')),0)
SET @pIncluir_Ajustes          	= ISNULL(CONVERT(SMALLINT, dbo.CF_JSON_VALUE(@pJsonRecibido,'Incluir_Ajustes')),0)
SET @pId_Plan_Cta           	= ISNULL(CONVERT(SMALLINT, dbo.CF_JSON_VALUE(@pJsonRecibido,'Id_Plan_Cta')),0)
SET @pGenerar_Asiento           = ISNULL(CONVERT(TINYINT, dbo.CF_JSON_VALUE(@pJsonRecibido,'Generar_Asiento')),0)
SET @pFecha                     = ISNULL(CONVERT(DATETIME, dbo.CF_JSON_VALUE(@pJsonRecibido,'Fecha')),GETDATE())
SET @pDescripcion			    = ISNULL(CONVERT(VARCHAR(100), dbo.CF_JSON_VALUE(@pJsonRecibido,'Descripcion')),'')
 
  DECLARE @Sql		    VARCHAR(MAX)
  DECLARE @SqlSaldo	    VARCHAR(MAX)
  DECLARE @SqlSelect	VARCHAR(MAX)
  DECLARE @SqlInto	    VARCHAR(MAX)
  DECLARE @SqlFrom	    VARCHAR(MAX)
  DECLARE @SqlWhere  	VARCHAR(MAX)
  DECLARE @SqlGroup	    VARCHAR(MAX)

  DECLARE @Id_Asiento       int
  DECLARE @Item             int
  DECLARE @Nro              int
  DECLARE @Importe          Decimal(16,2)
  
  DECLARE @Id_Cta_Contable     INT
			       ,@Id_Alias_Cta_Cont   INT
				   ,@Debe                DECIMAL(14,2)
				   ,@Haber               DECIMAL(14,2)
				   ,@Id_Centro_Costo     CHAR(10)

   Set @Item = 0

    CREATE TABLE [dbo].[#Asiento](
	[Id_Cta_Contable] [int] NULL,
	[Alias] [smallint] NULL,
	[Nro_Cta_Contable] [varchar](20) NULL,
	[Descripcion_Cta] [varchar](80) NULL,
	[Centro_Costo] [char](10) NOT NULL,
	[Descripcion_CC] [varchar](200) NULL,
	[Debe] [decimal](14, 2) NULL,
	[Haber] [decimal](14, 2) NULL
     ) 

   CREATE TABLE #CBTES_ACTUALIZAR (ID_TRANS INT)

   SELECT ID_UNID_NEGOCIO INTO #UN FROM Empresas_Unid_Negocios
   		IF (@pId_Unid_Negocio) <> ''
			DELETE #UN WHERE ID_UNID_NEGOCIO <> @pId_Unid_Negocio 

-------------  

   UPDATE CBTES_TIPOS SET  Compromete_Recibos      = 0 WHERE Compromete_Recibos IS NULL
   UPDATE CBTES_TIPOS SET  Compromete_Asientos     = 0 WHERE Compromete_Asientos IS NULL
   UPDATE CBTES_TIPOS SET  Compromete_Compras      = 0 WHERE Compromete_Compras IS NULL
   UPDATE CBTES_TIPOS SET  Compromete_Pagos        = 0 WHERE Compromete_Pagos IS NULL
   UPDATE CBTES_TIPOS SET  Compromete_Trans_Fondos = 0 WHERE Compromete_Trans_Fondos IS NULL
   UPDATE CBTES_TIPOS SET  Compromete_Factura      = 0 WHERE Compromete_Factura IS NULL
   UPDATE CBTES_TIPOS SET  Compromete_Impuestos    = 0 WHERE Compromete_Impuestos IS NULL
   UPDATE Cbtes_Ctas_Contables SET ID_CENTRO_COSTO = '' WHERE ID_CENTRO_COSTO IS NULL
   UPDATE Cbtes_Ctas_Contables SET ID_ASIENTO = 0 WHERE ID_ASIENTO IS NULL

-------------
 

		SET @SqlSelect = ' INSERT INTO #Asiento 
		                    SELECT CC.Id_Cta_Contable
							,CC.Alias
							,P.Nro_Cta_Contable
							,P.Descripcion as Descripcion_Cta
							,CC.Id_Centro_Costo AS Centro_Costo
							,CO.Descripcion as Descripcion_CC
							,Sum(isnull(CC.Debe,0)) as Debe
							,0 as Haber '
 
		SET @SqlInto = ''

		SET @SqlFrom = ' FROM Cbtes_ctas_Contables CC, cbtes C, Cbtes_Tipos T, Pla_Ctas_Cuentas_Contables P, Centro_Costos CO , #UN U '

		SET @SqlWhere = ' WHERE   CC.ID_Trans = C.Id_Trans 
					AND CC.HABER = 0
					AND C.id_tipo_cbte = T.id_tipo_cbte 
					AND T.ID_UNID_NEGOCIO = U.ID_UNID_NEGOCIO
					AND CC.ID_CTA_CONTABLE = P.ID_CTA_CONTABLE 
					AND CO.ID_CENTRO_COSTO = CC.ID_CENTRO_COSTO
					and T.Compromete_Asientos in (1,-1)
					AND C.ID_ESTADO_CBTE NOT IN (0,3) '

 
		IF @pTipo = 1 
			SET @SqlWhere = RTRIM(LTRIM(@SqlWhere)) + ' AND T.Compromete_Compras in (1,-1) and T.Compromete_Recibos = 0 
	   													AND C.PERIODO_IVA >= ''' + CONVERT(VARCHAR(10), @pFechaDesde, 112) + '''  
														AND C.PERIODO_IVA < ''' + CONVERT(VARCHAR(10), DATEADD(DAY, 1, @pFechaHasta), 112) + ''' '

		IF @pTipo = 2 
			SET @SqlWhere = RTRIM(LTRIM(@SqlWhere)) + ' AND T.Compromete_Pagos in (1,-1) 
	   	   												AND C.FECHA >= ''' + CONVERT(VARCHAR(10), @pFechaDesde, 112) + '''  
														AND C.FECHA < ''' + CONVERT(VARCHAR(10), DATEADD(DAY, 1, @pFechaHasta), 112) + ''' '

		IF @pTipo = 3 
			SET @SqlWhere = RTRIM(LTRIM(@SqlWhere)) + ' AND T.Compromete_Factura in (1,-1) and T.Compromete_Trans_Fondos = 0 
	   	   												AND C.FECHA >= ''' + CONVERT(VARCHAR(10), @pFechaDesde, 112) + '''  
														AND C.FECHA < ''' + CONVERT(VARCHAR(10), DATEADD(DAY, 1, @pFechaHasta), 112) + ''' '

		IF @pTipo = 4 
			SET @SqlWhere = RTRIM(LTRIM(@SqlWhere)) + ' AND T.Compromete_Recibos in (1,-1) and T.Compromete_Trans_Fondos = 0 
	   	   												AND C.FECHA >= ''' + CONVERT(VARCHAR(10), @pFechaDesde, 112) + '''  
														AND C.FECHA < ''' + CONVERT(VARCHAR(10), DATEADD(DAY, 1, @pFechaHasta), 112) + ''' '

		IF @pTipo = 5 
			SET @SqlWhere = RTRIM(LTRIM(@SqlWhere)) + ' AND T.Compromete_Trans_Fondos in (1,-1)  
	   	   												AND C.FECHA >= ''' + CONVERT(VARCHAR(10), @pFechaDesde, 112) + '''  
														AND C.FECHA < ''' + CONVERT(VARCHAR(10), DATEADD(DAY, 1, @pFechaHasta), 112) + ''' '

		IF @pFiltrar_No_Contab = 1
			SET @SqlWhere = RTRIM(LTRIM(@SqlWhere)) + ' AND CC.Id_Asiento = 0  '

		If @pIncluir_Ajustes = 0 and @pTipo = 1 
			SET @SqlWhere = RTRIM(LTRIM(@SqlWhere)) + ' AND T.Compromete_Impuestos in (1,-1) '
	   

			SET @Sql = @SqlSelect + ' ' + @SqlInto +' '+ @SqlFrom + ' ' + @SqlWhere + ' GROUP BY CC.Id_Cta_Contable
							,CC.Alias
							,P.Nro_Cta_Contable
							,P.Descripcion 
							,CC.Id_Centro_Costo
							,CO.Descripcion'
	  
		print @Sql

 		EXEC(@sql)

		SET @SqlSelect = ' INSERT INTO #Asiento 
		                    SELECT CC.Id_Cta_Contable
							,CC.Alias
							,P.Nro_Cta_Contable
							,P.Descripcion as Descripcion_Cta
							,CC.Id_Centro_Costo AS Centro_Costo
							,CO.Descripcion as Descripcion_CC
							,0 as Debe
							,Sum(Isnull(CC.Haber,0)) as Haber '
 

		SET @SqlInto = ''

		SET @SqlFrom = ' FROM Cbtes_ctas_Contables CC, cbtes C, Cbtes_Tipos T, Pla_Ctas_Cuentas_Contables P, Centro_Costos CO , #UN U '

		SET @SqlWhere = ' WHERE   CC.ID_Trans = C.Id_Trans 
					AND CC.DEBE = 0
					AND C.id_tipo_cbte = T.id_tipo_cbte 
					AND T.ID_UNID_NEGOCIO = U.ID_UNID_NEGOCIO
					AND CC.ID_CTA_CONTABLE = P.ID_CTA_CONTABLE 
					AND CO.ID_CENTRO_COSTO = CC.ID_CENTRO_COSTO
					and T.Compromete_Asientos in (1,-1)
					AND C.ID_ESTADO_CBTE NOT IN (0,3)'

		IF @pTipo = 1 
			SET @SqlWhere = RTRIM(LTRIM(@SqlWhere)) + ' AND T.Compromete_Compras in (1,-1) and T.Compromete_Recibos = 0 
	   													AND C.PERIODO_IVA >= ''' + CONVERT(VARCHAR(10), @pFechaDesde, 112) + '''  
														AND C.PERIODO_IVA < ''' + CONVERT(VARCHAR(10), DATEADD(DAY, 1, @pFechaHasta), 112) + ''' '

		IF @pTipo = 2 
			SET @SqlWhere = RTRIM(LTRIM(@SqlWhere)) + ' AND T.Compromete_Pagos in (1,-1) 
	   	   												AND C.FECHA >= ''' + CONVERT(VARCHAR(10), @pFechaDesde, 112) + '''  
														AND C.FECHA < ''' + CONVERT(VARCHAR(10), DATEADD(DAY, 1, @pFechaHasta), 112) + ''' '

		IF @pTipo = 3 
			SET @SqlWhere = RTRIM(LTRIM(@SqlWhere)) + ' AND T.Compromete_Factura in (1,-1) and T.Compromete_Trans_Fondos = 0 
	   	   												AND C.FECHA >= ''' + CONVERT(VARCHAR(10), @pFechaDesde, 112) + '''  
														AND C.FECHA < ''' + CONVERT(VARCHAR(10), DATEADD(DAY, 1, @pFechaHasta), 112) + ''' '

		IF @pTipo = 4 
			SET @SqlWhere = RTRIM(LTRIM(@SqlWhere)) + ' AND T.Compromete_Recibos in (1,-1) and T.Compromete_Trans_Fondos = 0 
	   	   												AND C.FECHA >= ''' + CONVERT(VARCHAR(10), @pFechaDesde, 112) + '''  
														AND C.FECHA < ''' + CONVERT(VARCHAR(10), DATEADD(DAY, 1, @pFechaHasta), 112) + ''' '

		IF @pTipo = 5
			SET @SqlWhere = RTRIM(LTRIM(@SqlWhere)) + ' AND T.Compromete_Trans_Fondos in (1,-1)  
	   	   												AND C.FECHA >= ''' + CONVERT(VARCHAR(10), @pFechaDesde, 112) + '''  
														AND C.FECHA < ''' + CONVERT(VARCHAR(10), DATEADD(DAY, 1, @pFechaHasta), 112) + ''' '

		IF @pFiltrar_No_Contab = 1
			SET @SqlWhere = RTRIM(LTRIM(@SqlWhere)) + ' AND CC.Id_Asiento = 0  '

		If @pIncluir_Ajustes = 0 and @pTipo = 1 
			SET @SqlWhere = RTRIM(LTRIM(@SqlWhere)) + ' AND T.Compromete_Impuestos in (1,-1) '

			SET @Sql = @SqlSelect + ' ' + @SqlInto +' '+ @SqlFrom + ' ' + @SqlWhere + ' GROUP BY CC.Id_Cta_Contable
							,CC.Alias
							,P.Nro_Cta_Contable
							,P.Descripcion 
							,CC.Id_Centro_Costo
							,CO.Descripcion'
	  
			print @Sql

 			EXEC(@sql)


			select * from #Asiento where debe-haber <> 0  order by Nro_Cta_Contable,Centro_Costo,Haber


If @pGenerar_Asiento = 1 and (SELECT SUM(debe-haber) FROM #Asiento) = 0
   BEGIN
          --Genero Asiento

		    SET @Id_Asiento =  ISNULL((SELECT MAX(ID_ASIENTO) FROM ASIENTOS),0)+1
		    SET @Nro        =  Isnull((SELECT MAX(Nro) FROM ASIENTOS where Id_Plan_Cta = @pId_Plan_Cta),0)+1
			SET @Importe    =  (SELECT SUM(Debe) FROM #Asiento) 

			INSERT INTO ASIENTOS (Id_Asiento,Id_Plan_Cta,Id_Predef_Asi,Id_Tipo_Asi,Fecha
			                     ,Descripcion,Observacion,Importe,Balanceado,Nro
								 ,Resumido,Id_Unid_Negocio,Fecha_Desde,Fecha_Hasta)
                        VALUES (@Id_Asiento,@pId_Plan_Cta,0,@pTipo,@pFecha
						       ,@pDescripcion,'',@Importe,1,@Nro
							   ,1,@pId_Unid_Negocio,@pFechaDesde,@pFechaHasta)

		  --Genero items

          DECLARE CUR_GENERAR_ITEMS CURSOR FOR
				SELECT Id_Cta_Contable,Alias,Debe,Haber,Centro_Costo FROM #Asiento where debe-haber <> 0 and haber = 0 order by Nro_Cta_Contable,Centro_Costo
	
		  OPEN CUR_GENERAR_ITEMS
		  FETCH NEXT FROM CUR_GENERAR_ITEMS INTO @Id_Cta_Contable,@Id_Alias_Cta_Cont,@Debe,@Haber,@Id_Centro_Costo
		  WHILE @@FETCH_STATUS = 0
			  BEGIN

		      Set @Item += 1

		      INSERT INTO Asientos_Items ([Id_Asiento],[Item],[Id_Cta_Contable],[Id_Alias_Cta_Cont],
                                           [Debe],[Haber],[Id_Centro_Costo],[Nota],[Cantidad],[Precio])
                                   VALUES (@Id_Asiento,@Item,@Id_Cta_Contable,@Id_Alias_Cta_Cont,
								           @Debe,@Haber,@Id_Centro_Costo,'',0,0)

			  FETCH NEXT FROM CUR_GENERAR_ITEMS INTO @Id_Cta_Contable,@Id_Alias_Cta_Cont,@Debe,@Haber,@Id_Centro_Costo

		  END  
		  CLOSE CUR_GENERAR_ITEMS
		  DEALLOCATE CUR_GENERAR_ITEMS

          DECLARE CUR_GENERAR_ITEMS_H CURSOR FOR
				SELECT Id_Cta_Contable,Alias,Debe,Haber,Centro_Costo FROM #Asiento where debe-haber <> 0 and debe = 0 order by Nro_Cta_Contable,Centro_Costo
	
		  OPEN CUR_GENERAR_ITEMS_H
		  FETCH NEXT FROM CUR_GENERAR_ITEMS_H INTO @Id_Cta_Contable,@Id_Alias_Cta_Cont,@Debe,@Haber,@Id_Centro_Costo
		  WHILE @@FETCH_STATUS = 0
			  BEGIN

		      Set @Item += 1

		      INSERT INTO Asientos_Items ([Id_Asiento],[Item],[Id_Cta_Contable],[Id_Alias_Cta_Cont],
                                           [Debe],[Haber],[Id_Centro_Costo],[Nota],[Cantidad],[Precio])
                                   VALUES (@Id_Asiento,@Item,@Id_Cta_Contable,@Id_Alias_Cta_Cont,
								           @Debe,@Haber,@Id_Centro_Costo,'',0,0)

			  FETCH NEXT FROM CUR_GENERAR_ITEMS_H INTO @Id_Cta_Contable,@Id_Alias_Cta_Cont,@Debe,@Haber,@Id_Centro_Costo

		  END  
		  CLOSE CUR_GENERAR_ITEMS_H
		  DEALLOCATE CUR_GENERAR_ITEMS_H

		  --Actualizo 
		   SET @SqlSelect = ' INSERT INTO #CBTES_ACTUALIZAR SELECT DISTINCT(C.ID_TRANS) '

		   SET @SqlFrom = ' FROM Cbtes_ctas_Contables CC, cbtes C, Cbtes_Tipos T, Pla_Ctas_Cuentas_Contables P, Centro_Costos CO , #UN U '

		   SET @SqlWhere = ' WHERE   CC.ID_Trans = C.Id_Trans 
						AND C.id_tipo_cbte = T.id_tipo_cbte 
						AND T.ID_UNID_NEGOCIO = U.ID_UNID_NEGOCIO
						AND CC.ID_CTA_CONTABLE = P.ID_CTA_CONTABLE 
						AND CO.ID_CENTRO_COSTO = CC.ID_CENTRO_COSTO
						and T.Compromete_Asientos in (1,-1)
						AND C.ID_ESTADO_CBTE NOT IN (0,3) '

 
		   IF @pTipo = 1 
			   SET @SqlWhere = RTRIM(LTRIM(@SqlWhere)) + ' AND T.Compromete_Compras in (1,-1) and T.Compromete_Recibos = 0 
	   													   AND C.PERIODO_IVA >= ''' + CONVERT(VARCHAR(10), @pFechaDesde, 112) + '''  
														   AND C.PERIODO_IVA < ''' + CONVERT(VARCHAR(10), DATEADD(DAY, 1, @pFechaHasta), 112) + ''' '

		   IF @pTipo = 2 
			   SET @SqlWhere = RTRIM(LTRIM(@SqlWhere)) + ' AND T.Compromete_Pagos in (1,-1) 
	   	   												   AND C.FECHA >= ''' + CONVERT(VARCHAR(10), @pFechaDesde, 112) + '''  
														   AND C.FECHA < ''' + CONVERT(VARCHAR(10), DATEADD(DAY, 1, @pFechaHasta), 112) + ''' '

		   IF @pTipo = 3 
			   SET @SqlWhere = RTRIM(LTRIM(@SqlWhere)) + ' AND T.Compromete_Factura in (1,-1) and T.Compromete_Trans_Fondos = 0 
	   	   												   AND C.FECHA >= ''' + CONVERT(VARCHAR(10), @pFechaDesde, 112) + '''  
														   AND C.FECHA < ''' + CONVERT(VARCHAR(10), DATEADD(DAY, 1, @pFechaHasta), 112) + ''' '

		   IF @pTipo = 4 
			   SET @SqlWhere = RTRIM(LTRIM(@SqlWhere)) + ' AND T.Compromete_Recibos in (1,-1) and T.Compromete_Trans_Fondos = 0 
	   	   												   AND C.FECHA >= ''' + CONVERT(VARCHAR(10), @pFechaDesde, 112) + '''  
														   AND C.FECHA < ''' + CONVERT(VARCHAR(10), DATEADD(DAY, 1, @pFechaHasta), 112) + ''' '

		   IF @pTipo = 5 
			   SET @SqlWhere = RTRIM(LTRIM(@SqlWhere)) + ' AND T.Compromete_Trans_Fondos in (1,-1)  
	   	   												   AND C.FECHA >= ''' + CONVERT(VARCHAR(10), @pFechaDesde, 112) + '''  
														   AND C.FECHA < ''' + CONVERT(VARCHAR(10), DATEADD(DAY, 1, @pFechaHasta), 112) + ''' '

		   IF @pFiltrar_No_Contab = 1
			   SET @SqlWhere = RTRIM(LTRIM(@SqlWhere)) + ' AND CC.Id_Asiento = 0  '

		   If @pIncluir_Ajustes = 0 and @pTipo = 1 
			   SET @SqlWhere = RTRIM(LTRIM(@SqlWhere)) + ' AND T.Compromete_Impuestos in (1,-1) '
	   

		   SET @Sql = @SqlSelect +' '+ @SqlFrom + ' ' + @SqlWhere 
	  

 		   EXEC(@sql)

		   -- actualizo cbte_ctas_Contables


           UPDATE CBTES SET ID_ASIENTO = @Id_Asiento FROM CBTES C, #CBTES_ACTUALIZAR G
		          where c.id_trans = G.id_trans  

		   UPDATE CBTES_CTAS_CONTABLES SET ID_ASIENTO = @Id_Asiento
		         FROM #CBTES_ACTUALIZAR C, CBTES_CTAS_CONTABLES A 
		          where c.id_trans = A.id_trans 

    END

	DROP TABLE #UN
    DROP TABLE #CBTES_ACTUALIZAR
    DROP TABLE #Asiento
 

 
  
/*

  EXEC CPJ_Asiento_Resumen_Generar   '{"FechaDesde":"20220701","FechaHasta":"20220731","Id_Unid_Negocio":"","Filtrar_No_Contab":"0","Incluir_Ajustes":"0","Tipo":"1","Id_Plan_Cta":"4""Generar_Asiento":"1","fecha_asiento":"20220630","descripcion":"ASIENTO RESUMEN DE VENTAS"}'


SELECT * FROM ASIENTOS

SELECT * FROM CBTES  WHERE ID_ASIENTO = 241

SELECT * FROM CBTES_CTAS_CONTABLES WHERE ID_ASIENTO = 241

*/
